/*---
	WGS84̈ܓx,ox,ƒW(ECEF)̕ϊ
	2002.4.25: S.Fukushima(ENRI)	
---*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "def01.h"
#include "str01.h"

vector blh2ecef(double phi, double ramda, double height)
/* ܓx,ox,ECEFWɕϊ */
{
	vector ecef;

	ecef.n = 3;
	ecef.a[0] = (NN(phi)+height)*cos(phi*PI/180)*cos(ramda*PI/180);
	ecef.a[1] = (NN(phi)+height)*cos(phi*PI/180)*sin(ramda*PI/180);
	ecef.a[2] = (NN(phi)*(1-E2)+height)*sin(phi*PI/180);

	return ecef;
}

vector ecef2blh(vector ec)
/* ECEFWWGS84{ܓx,ox,ȉ~̍}֕ϊ */
{
	vector blh;
	int i = 0;
	double phi, ramda, height, p; 
	double x, y, z;
	double sita;

	ec.n = 3; blh.n = 3;
	x = ec.a[0], y = ec.a[1], z = ec.a[2];

	p = sqrt(x*x + y*y);
	sita = (180/PI) * atan2(z*A, p*B);

/*--- ܓx */
	phi = (180/PI) * atan2(z+ED2*B*(CUB(sin(sita*PI/180))),(p-E2*A*(CUB(cos(sita*PI/180)))));	

/*--- ox */
	ramda = (180/PI) * atan2(y,x);

/*---  */	
	height = (p / cos(phi*PI/180)) - NN(phi);   

	blh.a[0] = phi; blh.a[1] = ramda; blh.a[2] = height;
	return blh;
}

/*--- `FbNp
int main()
{
	double lat, lon, hig; 	
	vector ecef, blh;

	lat =  38.13579617;
	lon = 140.91581617;
	hig =  41.940;

	ecef = blh2ecef(lat, lon, hig);
	printf("%.3f %.3f %.3f\n", ecef.a[0], ecef.a[1], ecef.a[2]);

	blh = ecef2blh(ecef);
	printf("%.8f %.8f %.3f\n", blh.a[0], blh.a[1], blh.a[2]);
}
*/
/*---
	: -3899086.094 3166914.545 3917336.601
	           38.13579617 140.91581617 41.940
---*/
